%--------------------------------------------------------------------------
%   Universit catholique de Louvain
%   CEREM : Centre for research in energy and mechatronics
%   http://www.robotran.be  
%
%   Project : delta_full
%   Authors : P. Fisette and J.F. Collard
%   Year : 2012
%--------------------------------------------------------------------------

%% 1. Initialization and Project Loading [mbs_load]
%--------------------------------------------------------------------------
clc; close all; clear all;
global MBS_user;

% Project loading

[mbs_data] = mbs_load('delta','default');

% User_constraints

mbs_data.Nuserc = 3;

%% 2. Coordinate partitioning [mbs_exe_part]             % For constrained MBS only
%--------------------------------------------------------------------------
MBS_user.process = 'part';

mbs_data = mbs_set_qdriven(mbs_data,[1 2 3]);  % driven coordinates

opt.part = {'rowperm','yes','threshold',1e-9,'verbose','yes'};
[mbs_part,mbs_data] = mbs_exe_part(mbs_data,opt.part);

mbs_data.q(4:end) = mod(mbs_data.q(4:end),2*pi); % suppression of 2*k*pi

% Coordinate partitioning results
disp('Coordinate partitioning results');
disp(['Sorted independent variables = ', mat2str(mbs_part.ind_u)]);
disp(['Permutated dependent variables = ', mat2str(mbs_part.ind_v)]);
disp(['Permutated independent constraints = ', mat2str(mbs_part.hu)]);
disp(['Redundant constraints = ', mat2str(mbs_part.hv)]);
disp(' ');

mbs_data_closed = mbs_data;

%% 3. Inverse dynamics [mbs_exe_invdyn] : joints 10, 15, 20 actuated (see the Pad)
%---------------------------------------------------------------------------------
MBS_user.process = 'invdyn';
MBS_user.friction = 'no'; % 'yes' = with joint viscous friction, 'no' = without joint friction

mbs_data = mbs_data_closed; 

opt.invdyn = {'motion','trajectory','time',0:0.01:5,...
    'save2file','yes','renamefile','no','verbose','yes'};

[mbs_invdyn,mbs_data] = mbs_exe_invdyn(mbs_data,opt.invdyn);                % Inverse dynamics process

% Graphical Results
figure(3)
plot(mbs_invdyn.tsim,mbs_invdyn.Qa(:,mbs_data.qa));
grid;
title('Inverse dynamics: actuator torques'); 
xlabel('Time [s]');
ylabel('Torque [Nm]');
legend(['Actuated joint ',num2str(mbs_data.qa(1))],['Actuated joint ',num2str(mbs_data.qa(2))],['Actuated joint ',num2str(mbs_data.qa(3))]);

%% 4. Closing operations 
%--------------------------------------------------------------------------
mbs_rm_allprjpath;                                                          % Cleaning of the Matlab project paths
mbs_del_glob('MBS_user','MBS_info','MBS_data');                             % Cleaning of the global MBS variables
% clc;                                                                      % Cleaning of the Matlab command window
